clear all; close all hidden; format compact;

rotList = [10:40:330];

dataPath = '../../imagedata/ALOI_79';

dirs = dir(dataPath);
catNames = {dirs([dirs.isdir]).name};
catNames = setdiff(catNames, {'.', '..'});

tStart = tic;

for i = 1:numel(catNames)
    maxsize = 0;
    for j = 1:numel(rotList)
        file = [ fullfile(dataPath, catNames{i}) '/' catNames{i} '_r' int2str(rotList(j)) '.png' ];
        tmp = imread(file);
        intensity = sum(tmp, 3);
        darkMask = intensity <= 100;
        [rowIndices, colIndices] = find(darkMask==0);
        % Largest and smallest row indices
        sortedRow = sort(rowIndices);
        sortedCol = sort(colIndices);
        cutimage = tmp(sortedRow(5):sortedRow(length(sortedRow)-5), sortedCol(5):sortedCol(length(sortedCol)-5), :);
        rowwidth = sortedRow(length(sortedRow)-5)-sortedRow(5);
        colwidth = sortedCol(length(sortedCol)-5)-sortedCol(5);
        if rowwidth>maxsize
            maxsize = rowwidth;
        end
        if colwidth>maxsize
            maxsize = colwidth;
        end
    end
    scaleFactor = 256/maxsize;
    for j = 1:numel(rotList)
        file = [ fullfile(dataPath, catNames{i}) '/' catNames{i} '_r' int2str(rotList(j)) '.png' ];
        tmp = imread(file);
        intensity = sum(tmp, 3);
        darkMask = intensity <= 100;
        [rowIndices, colIndices] = find(darkMask==0);
        % Largest and smallest row indices
        sortedRow = sort(rowIndices);
        sortedCol = sort(colIndices);
        cutimage = tmp(sortedRow(5):sortedRow(length(sortedRow)-5), sortedCol(5):sortedCol(length(sortedCol)-5), :);
        rowwidth = sortedRow(length(sortedRow)-5)-sortedRow(5);
        colwidth = sortedCol(length(sortedCol)-5)-sortedCol(5);
        resizedImg = imresize(cutimage, scaleFactor);
        [newA, newB, newC] = size(resizedImg);
        if newA>256
            newA = 256;
            resizedImg = resizedImg(1:256, :, :);
        end
        if newB>256
            newB = 256;
            resizedImg = resizedImg(:, 1:256, :);
        end
        emptyimage = zeros(256, 256, 3, 'uint8');
        row1 = floor((256-newA)/2)+1;
        col1 = floor((256-newB)/2)+1;
        emptyimage(row1:(row1+newA-1), col1:(col1+newB-1), :) = resizedImg;
        % Separate the RGB channels
        R = emptyimage(:, :, 1);  % Red channel
        G = emptyimage(:, :, 2);  % Green channel
        B = emptyimage(:, :, 3);  % Blue channel
        % Apply imadjust to each channel separately
        R_adjusted = imadjust(R);
        G_adjusted = imadjust(G);
        B_adjusted = imadjust(B);
        % Recombine the adjusted channels into one RGB image
        adjustedImage = cat(3, R_adjusted, G_adjusted, B_adjusted);
        imwrite(adjustedImage, [catNames{i} '_r' int2str(rotList(j)) '.png'])
        grayImage = rgb2gray(emptyimage);
        grayImage = imadjust(grayImage, stretchlim(grayImage));
        % imwrite(grayImage, [catNames{i} '_r' int2str(rotList(j)) '.png'])
        [a, b, c] = fileparts(fullfile(file));
        fid = fopen(fullfile(a, b), 'w');
        fwrite(fid, grayImage', '*uint8');
        fclose(fid);
        FilterConv4(b, [ fullfile(dataPath, catNames{i}) '/' ], 0);
    end
end