% CreateImages.m. Create test images for VisNetMat1
N = 256; % 32 for a 32 x 32 image
Images = zeros(9, N*N); % 6 images here

mid = N/2;
index = 1;
for offset = -6 * N/32: 6 * N/32: 6 *N/32
    image = zeros(N, N);
    for row = 10 * N/32 : 22 * N/32
        for col = mid + offset -2 : mid + offset +2
            image(row, col) = 255;
         end
    end
    Images(index, :) = reshape(image', 1, N*N); % vertical bars
    Images(index + 3, :) = reshape(image, 1, N*N); % horizontal bars
    image = reshape(Images(index,:), N, N);
    image = imrotate(image', 45, 'crop'); % top left to bottom right
    figure(1);
    imagesc(image);
    title('Input data');
    colormap(gray);
    Images(index + 6, :) = reshape(image', 1, N*N); % diagonal bars
    index = index + 1;
    % pause
end
% save('Images256.mat', 'Images');
return % to just display

% now create flat 256x256 image files, with the column varying most rapidly
fid = fopen('v1', 'w');
fwrite(fid, Images(1,:), '*uint8');
fclose(fid);
fid = fopen('v2', 'w');
fwrite(fid, Images(2,:), '*uint8');
fclose(fid);
fid = fopen('v3', 'w');
fwrite(fid, Images(3,:), '*uint8');
fclose(fid);
fid = fopen('h1', 'w');
fwrite(fid, Images(4,:), '*uint8');
fclose(fid);
fid = fopen('h2', 'w');
fwrite(fid, Images(5,:), '*uint8');
fclose(fid);
fid = fopen('h3', 'w');
fwrite(fid, Images(6,:), '*uint8');
fclose(fid);
fid = fopen('d1', 'w');
fwrite(fid, Images(7,:), '*uint8');
fclose(fid);
fid = fopen('d2', 'w');
fwrite(fid, Images(8,:), '*uint8');
fclose(fid);
fid = fopen('d3', 'w');
fwrite(fid, Images(9,:), '*uint8');
fclose(fid);

