function phim = phims(val, mean, sigma)
% For infors_visnet
    h = val - mean;
    if (h == 0.)
       phim = 0.5;
       return;
    elseif (h * h > 25.0 * sigma)
       if (h > 0.)
           phim = 1.0;
 	       return;
       else
           phim = 0.0;
           return;
       end
    else
    h = h / sqrt(sigma);
    z = sqrt(0.5 * h * h);
    t = 1.0 / (1.0 + 0.5 * z);
    erfcc = t * exp(-z * z - 1.26551223 + ...
 	      t * (1.00002368 + t * (0.37409196 + ...
 			      t * (0.09678418 + t * (-0.18628806 + ...
 					      t * (0.27886807 + t * (-1.13520398 + ...
 							      t * (1.48851587 + t * (-0.82215223 + ...
 									      t * 0.17087277)))))))));
% /*      fprintf(stderr,"h %3.1f z %3.1f t %6.3f erfcc %6.3f\n",h,z,t,erfcc); */
    if (h < 0.)
        phim = 0.5 * erfcc;
    else
        phim = 1.0 - 0.5 * erfcc;
% /*      fprintf(stderr,"phim %6.3f\n",phim); */
    end
    return;
end
 