function test(SweepFilename)
    % Now we need some test and analysis functions, and a GUI to access EFR_L4 etc !
    % copyright E T Rolls, Oxford Centre for Computational Neuroscience
    
    % First, let us build a data array by presenting all the objects in all views in all locations, and saving the EFR firing rates for all layers
    % EFRDATA(Image, View, loc, layer, Row, Col) % The C version
    % EFRDATA(Image, View, layer, EFR) % The Matlab version
    
    disp(['Testing the network with the stimuli, and saving the data in ' SweepFilename]);

    global EFR EFRDATA NLAYERS NET_SIZE SQNET_SIZE N_FILES N_GROUPS N_VIEWS N_LOCS BESTCELLS NBESTCELLS ...
       NBESTCELLSINFORM NTRANSFORMS PARAMETER_LIST SYNMAT SYNMAT_CHANGE ...
       SYNMAT_CHANGE_GROUP LOGNUM FIXEDTRACE SPARSENESS BETA ETA LRNRATE NSYN SYNMATL1 SYNMATL2 SYNMATL3 ...
       SYNMATL4 VNLOGINDEX IMLIST IMLIST_TEST N_VIEWS_TEST FILTIM NSYNL1 Images base_dir image_dir ...
       FiltImSize SqFiltImSize Display ...
       filter_layer_1 filter_layer_2  filter_layer_3 filter_layer_4 SIGMOID LATERALINHIB TraceDisp DisplaySYNMATprevious ...
       NORM MAX_WEIGHTS
    
    % calculate the rates for layers 1-4 for all views (and later locations) for EFRDATA
    for group = 1 : N_GROUPS
        group;
        for view = 1 : N_VIEWS_TEST
            view;
            im = view + (group - 1) * N_VIEWS_TEST;    % the image numbers start at 1, with n_VIEWS images or files per group
            image_name = char(IMLIST_TEST(im, 1));
            image_dir = strcat(base_dir, image_name, '.filtered/');
            f_filt = fopen(strcat(image_dir, image_name,'.filt'), 'r');
            FILTIM = fread(f_filt);
            fclose(f_filt);
            FILTIM = FILTIM';
            if Display >= 1
                %disp(['layer=', num2str(layer), '  group=', num2str(group), '  view=', num2str(view)]);
                i = 5; % should be the vertical pos filter; default 5
                figure(10);
                tmpFiltim = FILTIM;
                tmpFiltim = reshape(tmpFiltim, SqFiltImSize, 32);
                tmp = tmpFiltim(:, i);
                tmp =reshape(tmp, FiltImSize, FiltImSize);
                imagesc(tmp');
                colormap(gray);
                title(['  group=', num2str(group), '  view=', num2str(view), ' Filter= ', num2str(i)]);
                max(max(tmp));
            end

            for layer = 1 : 4
                if layer == 1
                    EFR(:, layer) = FILTIM * SYNMATL1; % activation
                    if LATERALINHIB == 1  
                       tmpD=EFR(:,layer);
                       tmpD = reshape(EFR(:,layer), NET_SIZE, NET_SIZE);
                       tmpE = conv2(tmpD, filter_layer_1, 'same');  % like Tinhibition
                       EFR(:, layer) = reshape(tmpE, 1, NET_SIZE * NET_SIZE);
                    end
                elseif layer == 2
                    EFR(:, layer) = EFR(:, layer - 1)' * SYNMATL2; % activation
                    if LATERALINHIB == 1
                       tmpD=EFR(:,layer);
                       tmpD = reshape(EFR(:,layer), NET_SIZE, NET_SIZE);
                       tmpE = conv2(tmpD, filter_layer_2, 'same');  % like Tinhibition
                       EFR(:, layer) = reshape(tmpE, 1, NET_SIZE * NET_SIZE);
                    end
                elseif layer == 3
                    EFR(:, layer) = EFR(:, layer - 1)' * SYNMATL3; % activation
                    if LATERALINHIB == 1
                       tmpD=EFR(:,layer);
                       tmpD = reshape(EFR(:,layer), NET_SIZE, NET_SIZE);
                       tmpE = conv2(tmpD, filter_layer_3, 'same');  % like Tinhibition
                       EFR(:, layer) = reshape(tmpE, 1, NET_SIZE * NET_SIZE);
                    end
                elseif layer == 4
                    EFR(:, layer) = EFR(:, layer - 1)' * SYNMATL4; % activation
                    if LATERALINHIB == 1
                       tmpD=EFR(:,layer);
                       tmpD = reshape(EFR(:,layer), NET_SIZE, NET_SIZE);
                       tmpE = conv2(tmpD, filter_layer_4, 'same');  % like Tinhibition
                       EFR(:, layer) = reshape(tmpE, 1, NET_SIZE * NET_SIZE);
                    end
                end        
                mn = min(EFR(:, layer));        % convert to Rate using sparseness and threshold linear activation function
                mx = max(EFR(:, layer));
                EFR(:, layer) = (EFR(:, layer) - mn);
                EFR(:, layer) = EFR(:, layer) / (mx - mn); 
                tmp = sort(EFR(:, layer), 'descend');
                Threshold = tmp(floor(SQNET_SIZE * SPARSENESS(layer)));
                
                if SIGMOID == 1  % following is for sigmoid
                    EFR(:, layer) = EFR(:, layer) - Threshold; % shift the array so that the value is 0 at p,
                    beta = -2.0 * BETA(layer);   % beta = -2(r-)
                    for neuron = 1 : SQNET_SIZE
                        d = beta * EFR(neuron, layer);
                        if d > 70.0
                            EFR(neuron, layer) = 0.0;
                        elseif d < -50.0
                            EFR(neuron, layer) = 1.0;
                        else
                            EFR(neuron, layer) = 1.0 / (1.0 + exp(d));
                        end
                    end
                else % threshold linear
                    for neuron = 1 : SQNET_SIZE
                        if EFR(neuron, layer) < Threshold
                            EFR(neuron, layer) = 0;
                        %else
                            %EFR(neuron, layer) = EFR(neuron, layer);
                        end
                    end
                end
                mn = min(EFR(:, layer));        % scale Rate 0-1. 24 Jul 2024
                mx = max(EFR(:, layer));
                EFR(:, layer) = (EFR(:, layer) - mn);
                EFR(:, layer) = EFR(:, layer) / (mx - mn);
                EFRDATA(group, view, layer, :) = EFR(:, layer);
            end % of layer: now we have the rate in all layers for testing

            if Display >= 2
                figure(3);
                tmp = EFR(:, 4);
                tmp =reshape(tmp, NET_SIZE, NET_SIZE);
                imagesc(tmp');
                colormap(gray);
                title([' Rate ', ' layer=', num2str(4), '  group=', num2str(group), '  view=', num2str(view)]);
                disp(['layer=', num2str(4), '  group=', num2str(group), '  view=', num2str(view)]);
                xlabel('X');
                ylabel('Y');
                drawnow
                %pause
            end
        end % of view
    end % of group

    % save the file in hdf5 format: see "How to store large datasets_ _Matlabtips.pdf"
    save(SweepFilename,'EFRDATA','N_GROUPS', 'N_VIEWS_TEST', '-v7.3'); % version 7.3 is good for matfile operations
    %save(SweepFilename,'EFRDATA','N_GROUPS', 'N_VIEWS_TEST'); % Octave
    %tmp = strcat('copy ', ' ', SweepFilename, ' ../VNanalysis/Sweep.mat'); %copy it to Sweep.mat, as this is needed for the gui. For Linux
    tmp = ['copy ', SweepFilename, ' ..\VNanalysis\Sweep.mat']    % copy it to Sweep.mat, as this is needed for the gui
    system(tmp);

    if 0
        disp('Accessing Sweep.mat, and plotting a layer 4 firing rate array');
        % demonstrate how to load an EFR firing rate matrix for a given object,view,loc,layer
        PointToMat = matfile('../VNanalysis/Sweep.mat');
        EFRdemo = PointToMat.EFRDATA(1,1,4,:);
        EFRdemo = reshape(EFRdemo, [NET_SIZE NET_SIZE]);
        %size(EFRdemo);
        figure(3);
        pcolor(EFRdemo);
        colormap(gray(256));
        drawnow;
    end
end

